<?php
/******************************************************************************
* Admin.php                                                                   *
*******************************************************************************
* SMF: Simple Machines Forum                                                  *
* Open-Source Project Inspired by Zef Hemel (zef@zefhemel.com)                *
* =========================================================================== *
* Software Version:           SMF 1.1 RC2                                     *
* Software by:                Simple Machines (http://www.simplemachines.org) *
* Copyright 2001-2005 by:     Lewis Media (http://www.lewismedia.com)         *
* Support, News, Updates at:  http://www.simplemachines.org                   *
*******************************************************************************
* This program is free software; you may redistribute it and/or modify it     *
* under the terms of the provided license as published by Lewis Media.        *
*                                                                             *
* This program is distributed in the hope that it is and will be useful,      *
* but WITHOUT ANY WARRANTIES; without even any implied warranty of            *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.                        *
*                                                                             *
* See the "license.txt" file for details of the Simple Machines license.      *
* The latest version can always be found at http://www.simplemachines.org.    *
******************************************************************************/
if (!defined('SMF'))
	die('Hacking attempt...');

/*	This file, unpredictable as this might be, handles basic administration.
	The most important function in this file for mod makers happens to be the
	updateSettingsFile() function, but it shouldn't be used often anyway.

	void Admin()
		- prepares all the data necessary for the administration front page.
		- uses the Admin template along with the admin sub template.
		- requires the moderate_forum, manage_membergroups, manage_bans,
		  admin_forum, manage_permissions, manage_attachments, manage_smileys,
		  manage_boards, edit_news, or send_mail permission.
		- uses the index administrative area.
		- can be found by going to ?action=admin.

	void OptimizeTables()
		- optimizes all tables in the database and lists how much was saved.
		- requires the admin_forum permission.
		- uses the rawdata sub template (built in.)
		- shows as the maintain_forum admin area.
		- updates the autoOptLastOpt setting such that the tables are not
		  automatically optimized again too soon.
		- accessed from ?action=optimizetables.

	void Maintenance()
		- shows a listing of maintenance options - including repair, recount,
		  optimize, database dump, clear logs, and remove old posts.
		- handles directly the tasks of clearing logs.
		- requires the admin_forum permission.
		- uses the maintain_forum admin area.
		- shows the maintain sub template of the Admin template.
		- accessed by ?action=maintain.

	void AdminBoardRecount()
		- recounts many forum totals that can be recounted automatically
		  without harm.
		- requires the admin_forum permission.
		- shows the maintain_forum admin area.
		- fixes topics with wrong numReplies.
		- updates the numPosts and numTopics of all boards.
		- recounts instantMessages but not unreadMessages.
		- repairs messages pointing to boards with topics pointing to
		  other boards.
		- updates the last message posted in boards and children.
		- updates member count, latest member, topic count, and message count.
		- redirects back to ?action=maintain when complete.
		- accessed via ?action=boardrecount.

	void VersionDetail()
		- parses the comment headers in all files for their version information
		  and outputs that for some javascript to check with simplemacines.org.
		- does not connect directly with simplemachines.org, but rather
		  expects the client to.
		- requires the admin_forum permission.
		- uses the view_versions admin area.
		- loads the view_versions sub template (in the Admin template.)
		- accessed through ?action=detailedversion.

	void CleanupPermissions()
		- cleans up file permissions, in the hopes of making things work
		  smoother and potentially more securely.
		- can set permissions to either restrictive, free, or standard.
		- accessed via ?action=cleanperms.

	void updateSettingsFile(array config_vars)
		- updates the Settings.php file with the changes in config_vars.
		- expects config_vars to be an associative array, with the keys as the
		  variable names in Settings.php, and the values the varaible values.
		- does not escape or quote values.
		- preserves case, formatting, and additional options in file.
		- writes nothing if the resulting file would be less than 10 lines
		  in length (sanity check for read lock.)
*/

// The main administration section.
function Admin()
{
	global $sourcedir, $db_prefix, $forum_version, $txt, $scripturl, $context, $user_info;

	// You have to be able to do at least one of the below to see this page.
	isAllowedTo(array('admin_forum', 'manage_permissions', 'moderate_forum', 'manage_membergroups', 'manage_bans', 'send_mail', 'edit_news', 'manage_boards', 'manage_smileys', 'manage_attachments'));

	// Load the common admin stuff... select 'index'.
	adminIndex(isset($_GET['credits']) ? 'credits' : 'index');

	// Find all of this forum's administrators.
	$request = db_query("
		SELECT ID_MEMBER, realName
		FROM {$db_prefix}members
		WHERE ID_GROUP = 1 OR FIND_IN_SET(1, additionalGroups)
		LIMIT 33", __FILE__, __LINE__);
	$context['administrators'] = array();
	while ($row = mysql_fetch_assoc($request))
		$context['administrators'][] = '<a href="' . $scripturl . '?action=profile;u=' . $row['ID_MEMBER'] . '">' . $row['realName'] . '</a>';
	mysql_free_result($request);

	// If there are more than 32 admins show a more link and direct the admin to the memberlist with admin filter.
	if (count($context['administrators']) > 32)
	{
		// Quicker to get one too many than to count first...
		unset($context['administrators'][32]);
		$context['more_admins_link'] = '<a href="' . $scripturl . '?action=mlist;sa=search;fields=group;search=administrator">' . $txt['more'] . '</a>';
	}

	// Some stuff.... :P.
	$context['credits'] = '
<i>Simple Machines wants to thank everyone who helped make SMF 1.1 what it is today; shaping and directing our project, all through the thick and the thin. It wouldn\'t have been possible without you.</i><br />
<div style="margin-top: 1ex;"><i>This includes our users and especially Charter Members - thanks for installing and using our software as well as providing valuable feedback, bug reports, and opinions.</i></div>
<div style="margin-top: 2ex;"><b>Project Managers:</b> Jeff Lewis, Joseph Fung, and David Recordon.</div>
<div style="margin-top: 1ex;"><b>Developers:</b> Unknown W. &quot;[Unknown]&quot; Brackets, Hendrik Jan &quot;Compuart&quot; Visser, Matt &quot;Grudge&quot; Wolf, and Philip &quot;Meriadoc&quot; Renich</div>
<div style="margin-top: 1ex;"><b>Support Specialists:</b> Andrea Hubacher, Alexandre &quot;Ap2&quot; Patenaude, Ben Scott, [darksteel], Horseman, Justyne, Killer Possum, Mediman, Methonis, Michael &quot;Oldiesmann&quot; Eshom, Omar Bazavilvazo, Osku &quot;Owdy&quot; Uusitupa, Pitti, and Tomer &quot;Lamper&quot; Dean.</div>
<div style="margin-top: 1ex;"><b>Mod Developers:</b> Jack.R.Abbit, Aliencowfarm, Chris Cromer, Cristi&aacute;n &quot;Anguz&quot; L&aacute;vaque, James &quot;Cheschire&quot; Yarbro, Jesse &quot;Gobalopper&quot; Reid.</div>
<div style="margin-top: 1ex;"><b>Documentation Writers:</b> Amacythe, Jerry, Nave, and Matthew "Mattitude" Hall.</div>
<div style="margin-top: 1ex;"><b>Language Coordinators:</b> Adam &quot;Bostasp&quot; Southall and Daniel Diehl.</div>
<div style="margin-top: 1ex;"><b>Graphic Designers:</b> A.M.A, Alienine (Adrian), Babylonking, Bjoern "Bloc" Kristiansen, Burpee, Diplomat, Kirby, Mystica, and &lt;? Piranha($fx); ?&gt;.</div>
<div style="margin-top: 1ex;">And for anyone we may have missed, thank you!</div>';

	// This makes it easier to get the latest news with your time format.
	$context['time_format'] = urlencode($user_info['time_format']);

	$context['current_versions'] = array(
		'php' => array('title' => $txt['support_versions_php'], 'version' => PHP_VERSION),
		'mysql' => array('title' => $txt['support_versions_mysql'], 'version' => ''),
		'server' => array('title' => $txt['support_versions_server'], 'version' => $_SERVER['SERVER_SOFTWARE']),
	);
	$context['forum_version'] = $forum_version;

	// Is GD available?  If it is, we should show version information for it too.
	if (function_exists('gd_info'))
	{
		$temp = gd_info();
		$context['current_versions']['gd'] = array('title' => $txt['support_versions_gd'], 'version' => $temp['GD Version']);
	}

	$request = db_query("
		SELECT VERSION()", __FILE__, __LINE__);
	list ($context['current_versions']['mysql']['version']) = mysql_fetch_row($request);
	mysql_free_result($request);

	// Check to see if we have any accelerators installed...
	if (defined('MMCACHE_VERSION'))
		$context['current_versions']['mmcache'] = array('title' => 'Turck MMCache', 'version' => MMCACHE_VERSION);
	if (defined('EACCELERATOR_VERSION'))
		$context['current_versions']['eaccelerator'] = array('title' => 'eAccelerator', 'version' => EACCELERATOR_VERSION);
	if (isset($GLOBALS['_PHPA']))
		$context['current_versions']['phpa'] = array('title' => 'ionCube PHP-Accelerator', 'version' => $GLOBALS['_PHPA']['VERSION']);
	if (extension_loaded('apc'))
		$context['current_versions']['apc'] = array('title' => 'Alternative PHP Cache', 'version' => phpversion('apc'));

	$context['can_admin'] = allowedTo('admin_forum');

	$context['sub_template'] = isset($_GET['credits']) ? 'credits' : 'admin';
	$context['page_title'] = isset($_GET['credits']) ? $txt['support_credits_title'] : $txt[208];

	// The format of this array is: permission, action, title, description.
	$quick_admin_tasks = array(
		array('', 'admin;credits', 'support_credits_title', 'support_credits_info'),
		array('admin_forum', 'featuresettings', 'modSettings_title', 'modSettings_info'),
		array('admin_forum', 'maintain', 'maintain_title', 'maintain_info'),
		array('manage_permissions', 'permissions', 'edit_permissions', 'edit_permissions_info'),
		array('admin_forum', 'theme;sa=admin;sesc=' . $context['session_id'], 'theme_admin', 'theme_admin_info'),
		array('admin_forum', 'packages', 'package1', 'package_info'),
		array('manage_smileys', 'smileys', 'smileys_manage', 'smileys_manage_info'),
		array('moderate_forum', 'viewmembers', '5', 'member_center_info'),
	);

	$context['quick_admin_tasks'] = array();
	foreach ($quick_admin_tasks as $task)
	{
		if (!empty($task[0]) && !allowedTo($task[0]))
			continue;

		$context['quick_admin_tasks'][] = array(
			'href' => $scripturl . '?action=' . $task[1],
			'link' => '<a href="' . $scripturl . '?action=' . $task[1] . '">' . $txt[$task[2]] . '</a>',
			'title' => $txt[$task[2]],
			'description' => $txt[$task[3]],
			'is_last' => false
		);
	}

	if (count($context['quick_admin_tasks']) % 2 == 1)
	{
		$context['quick_admin_tasks'][] = array(
			'href' => '',
			'link' => '',
			'title' => '',
			'description' => '',
			'is_last' => true
		);
		$context['quick_admin_tasks'][count($context['quick_admin_tasks']) - 2]['is_last'] = true;
	}
	elseif (count($context['quick_admin_tasks']) != 0)
	{
		$context['quick_admin_tasks'][count($context['quick_admin_tasks']) - 1]['is_last'] = true;
		$context['quick_admin_tasks'][count($context['quick_admin_tasks']) - 2]['is_last'] = true;
	}
}

// Optimize the database's tables.
function OptimizeTables()
{
	global $db_name, $txt, $context, $scripturl;

	isAllowedTo('admin_forum');

	// Boldify "Maintain Forum".
	adminIndex('maintain_forum');

	ignore_user_abort(true);

	// Start with no tables optimized.
	$opttab = 0;

	$context['page_title'] = $txt['smf281'];
	$context['sub_template'] = 'optimize';

	// Get a list of tables, as well as how many there are.
	$result = db_query("
		SHOW TABLE STATUS
		FROM `$db_name`", false, false);
	$tables = array();

	if (!$result)
	{
		$result = db_query("
			SHOW TABLES
			FROM `$db_name`", __FILE__, __LINE__);
		while ($table = mysql_fetch_row($result))
			$tables[] = array('table_name' => $row[0]);
		mysql_free_result($result);
	}
	else
	{
		$i = 0;
		while ($table = mysql_fetch_assoc($result))
			$tables[] = $table + array('table_name' => mysql_tablename($result, $i++));
		mysql_free_result($result);
	}

	// If there aren't any tables then I believe that would mean the world has exploded...
	$context['num_tables'] = count($tables);
	if ($context['num_tables'] == 0)
		fatal_error('You appear to be running SMF in a flat file mode... fantastic!', false);

	// For each table....
	$context['optimized_tables'] = array();
	foreach ($tables as $table)
	{
		// Optimize the table!  We use backticks here because it might be a custom table.
		$result = db_query("
			OPTIMIZE TABLE `$table[table_name]`", __FILE__, __LINE__);
		$row = mysql_fetch_assoc($result);
		mysql_free_result($result);

		if (!isset($row['Msg_text']) || strpos($row['Msg_text'], 'already') === false || !isset($table['Data_free']) || $table['Data_free'] != 0)
			$context['optimized_tables'][] = array(
				'name' => $table['table_name'],
				'data_freed' => isset($table['Data_free']) ? $table['Data_free'] / 1024 : '<i>??</i>',
			);
	}

	// Number of tables, etc....
	$txt['smf282'] = sprintf($txt['smf282'], $context['num_tables']);
	$context['num_tables_optimized'] = count($context['optimized_tables']);

	updateSettings(array('autoOptLastOpt' => time()));
}

// Miscellaneous maintenance..
function Maintenance()
{
	global $context, $txt, $db_prefix, $user_info;

	isAllowedTo('admin_forum');

	adminIndex('maintain_forum');

	if (isset($_GET['sa']) && $_GET['sa'] == 'logs')
	{
		// No one's online now.... MUHAHAHAHA :P.
		db_query("
			DELETE FROM {$db_prefix}log_online", __FILE__, __LINE__);

		// Dump the banning logs.
		db_query("
			DELETE FROM {$db_prefix}log_banned", __FILE__, __LINE__);

		// Start ID_ERROR back at 0 and dump the error log.
		db_query("
			TRUNCATE {$db_prefix}log_errors", __FILE__, __LINE__);

		// Clear out the spam log.
		db_query("
			DELETE FROM {$db_prefix}log_floodcontrol", __FILE__, __LINE__);

		// Clear out the karma actions.
		db_query("
			DELETE FROM {$db_prefix}log_karma", __FILE__, __LINE__);

		// Last but not least, the search logs!
		db_query("
			TRUNCATE {$db_prefix}log_search_messages", __FILE__, __LINE__);
		db_query("
			TRUNCATE {$db_prefix}log_search_results", __FILE__, __LINE__);
		db_query("
			TRUNCATE {$db_prefix}log_search_subjects", __FILE__, __LINE__);

		updateSettings(array('search_pointer' => 0));

		$context['maintenance_finished'] = true;
	}
	elseif (isset($_GET['sa']) && $_GET['sa'] == 'destroy')
	{
		// Oh noes!
		echo '<html><head><title>', $context['forum_name'], ' deleted!</title></head>
			<body style="background-color: orange; font-family: arial, sans-serif; text-align: center;">
			<div style="margin-top: 8%; font-size: 400%; color: black;">Oh my, you killed ', $context['forum_name'], '!</div>
			<div style="margin-top: 7%; font-size: 500%; color: red;"><b>You lazy bum!</b></div>
			</body></html>';
		obExit(false);
	}
	else
		$context['maintenance_finished'] = isset($_GET['done']);

	// Grab some boards maintenance can be done on.
	$result = db_query("
		SELECT b.ID_BOARD, b.name, b.childLevel, c.name AS catName, c.ID_CAT
		FROM {$db_prefix}boards AS b
			LEFT JOIN {$db_prefix}categories AS c ON (c.ID_CAT = b.ID_CAT)
		WHERE $user_info[query_see_board]", __FILE__, __LINE__);
	$context['categories'] = array();
	while ($row = mysql_fetch_assoc($result))
	{
		if (!isset($context['categories'][$row['ID_CAT']]))
			$context['categories'][$row['ID_CAT']] = array(
				'name' => $row['catName'],
				'boards' => array()
			);

		$context['categories'][$row['ID_CAT']]['boards'][] = array(
			'id' => $row['ID_BOARD'],
			'name' => $row['name'],
			'child_level' => $row['childLevel']
		);
	}
	mysql_free_result($result);

	$context['sub_template'] = 'maintain';
	$context['page_title'] = $txt['maintain_title'];
}

// Recount all the important board totals.
function AdminBoardRecount()
{
	global $txt, $db_prefix, $context, $scripturl, $modSettings;

	isAllowedTo('admin_forum');

	// Select it on the left.
	adminIndex('maintain_forum');

	$context['page_title'] = $txt['not_done_title'];
	$context['continue_post_data'] = '';
	$context['continue_countdown'] = '3';
	$context['sub_template'] = 'not_done';

	// Try for as much time as possible, and get the time is seconds.
	@set_time_limit(600);
	$time_start = explode(' ', $GLOBALS['time_start']);
	$time_start = $time_start[0] + $time_start[1];

	// Step the number of topics at a time so things don't time out...
	$request = db_query("
		SELECT MAX(ID_TOPIC)
		FROM {$db_prefix}topics", __FILE__, __LINE__);
	list ($max_topics) = mysql_fetch_row($request);
	mysql_free_result($request);

	$increment = min(ceil($max_topics / 30), 2000);
	if (empty($_REQUEST['start']))
		$_REQUEST['start'] = 0;

	$total_steps = 5;

	// Get each topic with a wrong reply count and fix it - let's just do some at a time, though.
	if (empty($_REQUEST['step']))
	{
		$_REQUEST['step'] = 0;

		while ($_REQUEST['start'] < $max_topics)
		{
			$request = db_query("
				SELECT /*!40001 SQL_NO_CACHE */ t.ID_TOPIC, t.numReplies, COUNT(m.ID_MSG) - 1 AS realNumReplies
				FROM ({$db_prefix}topics AS t, {$db_prefix}messages AS m)
				WHERE m.ID_TOPIC = t.ID_TOPIC
					AND t.ID_TOPIC > " . ($_REQUEST['start']) . "
					AND t.ID_TOPIC <= " . ($_REQUEST['start'] + $increment) . "
				GROUP BY t.ID_TOPIC
				HAVING realNumReplies != numReplies", __FILE__, __LINE__);
			while ($row = mysql_fetch_assoc($request))
				db_query("
					UPDATE {$db_prefix}topics
					SET numReplies = $row[realNumReplies]
					WHERE ID_TOPIC = $row[ID_TOPIC]
					LIMIT 1", __FILE__, __LINE__);
			mysql_free_result($request);

			$_REQUEST['start'] += $increment;

			if (time() - $time_start > 5)
			{
				$context['continue_get_data'] = '?action=boardrecount;step=0;start=' . $_REQUEST['start'];
				$context['continue_percent'] = round((100 * $_REQUEST['start'] / $max_topics) / $total_steps);

				return;
			}
		}

		$_REQUEST['start'] = 0;
	}

	// Update the post and topic count of each board.
	if ($_REQUEST['step'] <= 1)
	{
		if (empty($_REQUEST['start']))
			db_query("
				UPDATE {$db_prefix}boards
				SET numPosts = 0, numTopics = 0", __FILE__, __LINE__);

		while ($_REQUEST['start'] < $max_topics)
		{
			$request = db_query("
				SELECT /*!40001 SQL_NO_CACHE */ t.ID_BOARD, COUNT(m.ID_MSG) AS realNumPosts, COUNT(DISTINCT t.ID_TOPIC) AS realNumTopics
				FROM ({$db_prefix}topics AS t, {$db_prefix}messages AS m)
				WHERE m.ID_TOPIC = t.ID_TOPIC
					AND m.ID_TOPIC > " . ($_REQUEST['start']) . "
					AND m.ID_TOPIC <= " . ($_REQUEST['start'] + $increment) . "
				GROUP BY t.ID_BOARD", __FILE__, __LINE__);
			while ($row = mysql_fetch_assoc($request))
				db_query("
					UPDATE {$db_prefix}boards
					SET numPosts = numPosts + $row[realNumPosts],
						numTopics = numTopics + $row[realNumTopics]
					WHERE ID_BOARD = $row[ID_BOARD]
					LIMIT 1", __FILE__, __LINE__);
			mysql_free_result($request);

			$_REQUEST['start'] += $increment;

			if (time() - $time_start > 5)
			{
				$context['continue_get_data'] = '?action=boardrecount;step=1;start=' . $_REQUEST['start'];
				$context['continue_percent'] = round((100 + 100 * $_REQUEST['start'] / $max_topics) / $total_steps);

				return;
			}
		}

		$_REQUEST['start'] = 0;
	}

	// Get all members with wrong number of personal messages.
	if ($_REQUEST['step'] <= 2)
	{
		$request = db_query("
			SELECT /*!40001 SQL_NO_CACHE */ mem.ID_MEMBER, COUNT(pmr.ID_PM) AS realNum, mem.instantMessages
			FROM {$db_prefix}members AS mem
				LEFT JOIN {$db_prefix}pm_recipients AS pmr ON (mem.ID_MEMBER = pmr.ID_MEMBER AND pmr.deleted = 0)
			GROUP BY mem.ID_MEMBER
			HAVING realNum != instantMessages", __FILE__, __LINE__);
		while ($row = mysql_fetch_assoc($request))
			updateMemberData($row['ID_MEMBER'], array('instantMessages' => $row['realNum']));
		mysql_free_result($request);

		$request = db_query("
			SELECT /*!40001 SQL_NO_CACHE */ mem.ID_MEMBER, COUNT(pmr.ID_PM) AS realNum, mem.unreadMessages
			FROM {$db_prefix}members AS mem
				LEFT JOIN {$db_prefix}pm_recipients AS pmr ON (mem.ID_MEMBER = pmr.ID_MEMBER AND pmr.deleted = 0 AND pmr.is_read = 0)
			GROUP BY mem.ID_MEMBER
			HAVING realNum != unreadMessages", __FILE__, __LINE__);
		while ($row = mysql_fetch_assoc($request))
			updateMemberData($row['ID_MEMBER'], array('unreadMessages' => $row['realNum']));
		mysql_free_result($request);
	}

	// Any messages pointing to the wrong board?
	if ($_REQUEST['step'] <= 3)
	{
		while ($_REQUEST['start'] < $modSettings['maxMsgID'])
		{
			$request = db_query("
				SELECT /*!40001 SQL_NO_CACHE */ t.ID_BOARD, m.ID_MSG
				FROM ({$db_prefix}messages AS m, {$db_prefix}topics AS t)
				WHERE t.ID_TOPIC = m.ID_TOPIC
					AND m.ID_MSG > $_REQUEST[start]
					AND m.ID_MSG <= " . ($_REQUEST['start'] + $increment) . "
					AND m.ID_BOARD != t.ID_BOARD", __FILE__, __LINE__);
			$boards = array();
			while ($row = mysql_fetch_assoc($request))
				$boards[$row['ID_BOARD']][] = $row['ID_MSG'];
			mysql_free_result($request);

			foreach ($boards as $board_id => $messages)
				db_query("
					UPDATE {$db_prefix}messages
					SET ID_BOARD = $board_id
					WHERE ID_MSG IN (" . implode(', ', $messages) . ")
					LIMIT " . count($messages), __FILE__, __LINE__);

			$_REQUEST['start'] += $increment;

			if (time() - $time_start > 5)
			{
				$context['continue_get_data'] = '?action=boardrecount;step=3;start=' . $_REQUEST['start'];
				$context['continue_percent'] = round((300 + 100 * $_REQUEST['start'] / $modSettings['maxMsgID']) / $total_steps);

				return;
			}
		}

		$_REQUEST['start'] = 0;
	}

	// Update the latest message of each board.
	$request = db_query("
		SELECT /*!40001 SQL_NO_CACHE */ b.ID_BOARD, b.ID_PARENT, b.ID_LAST_MSG, MAX(m.ID_MSG) AS localLastMsg, b.childLevel
		FROM ({$db_prefix}boards AS b, {$db_prefix}messages AS m)
		WHERE b.ID_BOARD = m.ID_BOARD
		GROUP BY ID_BOARD", __FILE__, __LINE__);
	$resort_me = array();
	while ($row = mysql_fetch_assoc($request))
		$resort_me[$row['childLevel']][] = $row;
	mysql_free_result($request);

	krsort($resort_me);

	$lastMsg = array();
	foreach ($resort_me as $rows)
		foreach ($rows as $row)
		{
			// The latest message is the latest of the current board and its children.
			if (isset($lastMsg[$row['ID_BOARD']]))
				$curLastMsg = max($row['localLastMsg'], $lastMsg[$row['ID_BOARD']]);
			else
				$curLastMsg = $row['localLastMsg'];

			// If what is and what should be the latest message differ, an update is necessary.
			if ($curLastMsg != $row['ID_LAST_MSG'])
				db_query("
					UPDATE {$db_prefix}boards
					SET ID_LAST_MSG = $curLastMsg
					WHERE ID_BOARD = $row[ID_BOARD]
					LIMIT 1", __FILE__, __LINE__);

			// Parent boards inherit the latest message of their children.
			if (isset($lastMsg[$row['ID_PARENT']]))
				$lastMsg[$row['ID_PARENT']] = max($row['localLastMsg'], $lastMsg[$row['ID_PARENT']]);
			else
				$lastMsg[$row['ID_PARENT']] = $row['localLastMsg'];
		}

	// Update all the basic statistics.
	updateStats('member');
	updateStats('message');
	updateStats('topic');

	redirectexit('action=maintain;done');
}

// Perform a detailed version check.  A very good thing ;).
function VersionDetail()
{
	global $forum_version;
	global $txt, $boarddir, $sourcedir, $context, $settings;

	isAllowedTo('admin_forum');

	// Set up the sidebar for version checking.
	adminIndex('view_versions');

	$context['file_versions'] = array();
	$context['default_template_versions'] = array();
	$context['template_versions'] = array();
	$context['default_language_versions'] = array();

	// Find the version in SSI.php's file header.
	$fp = fopen($boarddir . '/SSI.php', 'rb');
	$header = fread($fp, 4096);
	fclose($fp);

	// The comment looks rougly like... that.
	if (preg_match('~\*\s*Software\s+Version:\s+SMF\s+(.+?)[\s]{2}~i', $header, $match) == 1)
		$context['file_versions']['SSI.php'] = $match[1];
	// Not found!  This is bad.
	else
		$context['file_versions']['SSI.php'] = '??';

	// Load all the files in the Sources directory, except this file and the redirect.
	$Sources_dir = dir($sourcedir);
	while ($entry = $Sources_dir->read())
		if (substr($entry, -4) == '.php' && !is_dir($sourcedir . '/' . $entry) && $entry != 'index.php')
		{
			// Read the first 4k from the file.... enough for the header.
			$fp = fopen($sourcedir . '/' . $entry, 'rb');
			$header = fread($fp, 4096);
			fclose($fp);

			// Look for the version comment in the file header.
			if (preg_match('~\*\s*Software\s+Version:\s+SMF\s+(.+?)[\s]{2}~i', $header, $match) == 1)
				$context['file_versions'][$entry] = $match[1];
			// It wasn't found, but the file was... show a '??'.
			else
				$context['file_versions'][$entry] = '??';
		}
	$Sources_dir->close();

	// Load all the files in the default template directory - and the current theme if applicable.
	$directories = array('default_template_versions' => $settings['default_theme_dir']);
	if ($settings['theme_id'] != 1)
		$directories += array('template_versions' => $settings['theme_dir']);

	foreach ($directories as $type => $dirname)
	{
		$This_dir = dir($dirname);
		while ($entry = $This_dir->read())
			if (substr($entry, -12) == 'template.php' && !is_dir($dirname . '/' . $entry))
			{
				// Read the first 768 bytes from the file.... enough for the header.
				$fp = fopen($dirname . '/' . $entry, 'rb');
				$header = fread($fp, 768);
				fclose($fp);

				// Look for the version comment in the file header.
				if (preg_match('~(?://|/\*)\s*Version:\s+(.+?);\s*' . preg_quote(basename($entry, '.template.php'), '~') . '(?:[\s]{2}|\*/)~i', $header, $match) == 1)
					$context[$type][$entry] = $match[1];
				// It wasn't found, but the file was... show a '??'.
				else
					$context[$type][$entry] = '??';
			}
		$This_dir->close();
	}

	// Load up all the files in the default language directory and sort by language.
	$lang_dir = $settings['default_theme_dir'] . '/languages';
	$This_dir = dir($lang_dir);
	while ($entry = $This_dir->read())
		if (substr($entry, -4) == '.php' && $entry != 'index.php' && !is_dir($lang_dir . '/' . $entry))
		{
			// Read the first 768 bytes from the file.... enough for the header.
			$fp = fopen($lang_dir . '/' . $entry, 'rb');
			$header = fread($fp, 768);
			fclose($fp);

			// Split the file name off into useful bits.
			list ($name, $language) = explode('.', $entry);

			// Look for the version comment in the file header.
			if (preg_match('~(?://|/\*)\s*Version:\s+(.+?);\s*' . preg_quote($name, '~') . '(?:[\s]{2}|\*/)~i', $header, $match) == 1)
				$context['default_language_versions'][$language][$name] = $match[1];
			// It wasn't found, but the file was... show a '??'.
			else
				$context['default_language_versions'][$language][$name] = '??';
		}
	$This_dir->close();

	// Sort the file versions by filename.
	ksort($context['file_versions']);
	ksort($context['default_template_versions']);
	ksort($context['template_versions']);
	ksort($context['default_language_versions']);

	// For languages sort each language too.
	foreach ($context['default_language_versions'] as $key => $dummy)
		ksort($context['default_language_versions'][$key]);

	$context['default_known_languages'] = array_keys($context['default_language_versions']);

	// Make it easier to manage for the template.
	$context['forum_version'] = $forum_version;

	$context['sub_template'] = 'view_versions';
	$context['page_title'] = $txt[429];
}

// Clean up the permissions one way or another.
function CleanupPermissions()
{
	global $boarddir, $sourcedir, $scripturl, $package_ftp, $modSettings;

	isAllowedTo('admin_forum');
	umask(0);

	loadTemplate('Packages');
	loadLanguage('Packages');

	if (!isset($_REQUEST['perm_type']) || !in_array($_REQUEST['perm_type'], array('free', 'restrictive', 'standard')))
		$_REQUEST['perm_type'] = 'free';

	checkSession();

	// FTP to the rescue!
	require_once($sourcedir . '/Subs-Package.php');
	packageRequireFTP($scripturl . '?action=cleanperms;perm_type=' . $_REQUEST['perm_type']);

	// The files that should be chmod'd are here - add any if you add any files with a modification.
	$special_files = array();
	$special_files['restrictive'] = array(
		'/attachments',
		'/custom_avatar_dir',
		'/Settings.php',
		'/Settings_bak.php',
	);
	$special_files['standard'] = array(
		'/attachments',
		'/avatars',
		'/custom_avatar_dir',
		'/Packages',
		'/Packages/installed.list',
		'/Smileys',
		'/Themes',
		'/agreement.txt',
		'/Settings.php',
		'/Settings_bak.php',
	);

	@chmod($boarddir . '/Settings.php', 0755);
	if (isset($package_ftp))
		$package_ftp->chmod(strtr($boarddir . '/Settings.php', array($_SESSION['pack_ftp']['root'] => '')), 0755);

	// If the owner of PHP is not nobody, this should probably pass through - in which case 755 is better than 777.
	if ((!function_exists('is_executable') || is_executable($boarddir . '/Settings.php')) && is_writable($boarddir . '/Settings.php'))
		$suexec_fix = 0755;
	else
		$suexec_fix = 0777;

	@chmod($boarddir, $_REQUEST['perm_type'] == 'free' ? $suexec_fix : 0755);
	if (isset($package_ftp))
		$package_ftp->chmod(strtr($boarddir . '/.', array($_SESSION['pack_ftp']['root'] => '')), $_REQUEST['perm_type'] == 'free' ? $suexec_fix : 0755);

	$dirs = array('' => $boarddir);

	if (substr($sourcedir, 0, strlen($boarddir)) != $boarddir)
		$dirs['/Sources'] = $sourcedir;
	if (substr($modSettings['attachmentUploadDir'], 0, strlen($boarddir)) != $boarddir)
		$dirs['/attachments'] = $modSettings['attachmentUploadDir'];
	if (substr($modSettings['smileys_dir'], 0, strlen($boarddir)) != $boarddir)
		$dirs['/Smileys'] = $modSettings['smileys_dir'];
	if (substr($modSettings['avatar_directory'], 0, strlen($boarddir)) != $boarddir)
		$dirs['/avatars'] = $modSettings['avatar_directory'];
	if (isset($modSettings['custom_avatar_dir']) && substr($modSettings['custom_avatar_dir'], 0, strlen($boarddir)) != $boarddir)
		$dirs['/custom_avatar_dir'] = $modSettings['custom_avatar_dir'];

	$done_dirs = array();
	while (count($dirs) > 0)
	{
		// The alias is what we know it as.  The attachments directory *could* be named "uploads".
		$temp = array_keys($dirs);
		$alias = $temp[0];

		// The actual full filename...
		$dirname = $dirs[$alias];
		unset($dirs[$alias]);

		$dir = dir($dirname);
		if (!$dir)
			continue;

		while ($entry = $dir->read())
		{
			if ($entry == '.' || $entry == '..')
				continue;

			// Figure out the filenames to chmod with...
			$filename = $dirname . '/' . $entry;
			$ftp_file = strtr($filename, array($_SESSION['pack_ftp']['root'] => ''));

			// Is this one we want writable?
			if ($_REQUEST['perm_type'] == 'free' || in_array($alias . '/' . $entry, $special_files[$_REQUEST['perm_type']]))
			{
				@chmod($filename, $suexec_fix);
				if (isset($package_ftp))
					$package_ftp->chmod($ftp_file, $suexec_fix);
			}
			// Not writable, just executable... yes?
			else
			{
				@chmod($filename, 0755);
				if (isset($package_ftp))
					$package_ftp->chmod($ftp_file, 0755);
			}

			// Directories get added to the todo list.
			if (@is_dir($filename) && !in_array($filename, $done_dirs))
				$dirs[$alias . '/' . $entry] = $filename;
		}

		$done_dirs[] = $dirname;
	}

	redirectexit('action=packages;sa=options');
}

// Update the Settings.php file.
function updateSettingsFile($config_vars)
{
	global $boarddir;

	// Load the file.  Break it up based on \r or \n, and then clean out extra characters.
	$settingsArray = file_get_contents($boarddir . '/Settings.php');
	if (strpos($settingsArray, "\n") !== false)
		$settingsArray = explode("\n", $settingsArray);
	elseif (strpos($settingsArray, "\r") !== false)
		$settingsArray = explode("\r", $settingsArray);
	else
		return;

	// Make sure we got a good file.
	if (count($config_vars) == 1 && isset($config_vars['db_last_error']))
	{
		$temp = trim(implode("\n", $settingsArray));
		if (substr($temp, 0, 5) != '<?php' || substr($temp, -2) != '?' . '>')
			return;
		if (strpos($temp, 'sourcedir') === false || strpos($temp, 'boarddir') === false || strpos($temp, 'cookiename') === false)
			return;
	}

	// Presumably, the file has to have stuff in it for this function to be called :P.
	if (count($settingsArray) < 10)
		return;

	foreach ($settingsArray as $k => $dummy)
		$settingsArray[$k] = strtr($dummy, array("\r" => '')) . "\n";

	for ($i = 0, $n = count($settingsArray); $i < $n; $i++)
	{
		// Don't trim or bother with it if it's not a variable.
		if (substr($settingsArray[$i], 0, 1) != '$')
			continue;

		$settingsArray[$i] = trim($settingsArray[$i]) . "\n";

		// Look through the variables to set....
		foreach ($config_vars as $var => $val)
		{
			if (strncasecmp($settingsArray[$i], '$' . $var, 1 + strlen($var)) == 0)
			{
				$comment = strstr(substr($settingsArray[$i], strpos($settingsArray[$i], ';')), '#');
				$settingsArray[$i] = '$' . $var . ' = ' . $val . ';' . ($comment == '' ? '' : "\t\t" . rtrim($comment)) . "\n";

				// This one's been 'used', so to speak.
				unset($config_vars[$var]);
			}
		}

		if (substr(trim($settingsArray[$i]), 0, 2) == '?' . '>')
			$end = $i;
	}

	// This should never happen, but apparently it is happening.
	if (empty($end) || $end < 10)
		$end = count($settingsArray) - 1;

	// Still more?  Add them at the end.
	if (!empty($config_vars))
	{
		if (trim($settingsArray[$end]) == '?' . '>')
			$settingsArray[$end++] = '';
		else
			$end++;

		foreach ($config_vars as $var => $val)
			$settingsArray[$end++] = '$' . $var . ' = ' . $val . ';' . "\n";
		$settingsArray[$end] = '?' . '>';
	}
	else
		$settingsArray[$end] = trim($settingsArray[$end]);

	// Sanity error checking: the file needs to be at least 12 lines.
	if (count($settingsArray) < 12)
		return;

	// Blank out the file - done to fix a oddity with some servers.
	$fp = @fopen($boarddir . '/Settings.php', 'w');

	// Is it even writable, though?
	if ($fp)
	{
		fclose($fp);

		$fp = fopen($boarddir . '/Settings.php', 'r+');
		foreach ($settingsArray as $line)
			fwrite($fp, strtr($line, "\r", ''));
		fclose($fp);
	}
}

?>